/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.swparasites;

import com.oblivioussp.spartanweaponry.item.ItemCrossbow;
import com.oblivioussp.spartanweaponry.item.ItemSwordBase;
import com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Utils {
    private static final Field ticksSinceLastAtt = ObfuscationReflectionHelper.findField(EntityLivingBase.class, (String)"field_184617_aD");
    private static final Field handInventory = ObfuscationReflectionHelper.findField(EntityLivingBase.class, (String)"field_184630_bs");
    private static final Field armorArray = ObfuscationReflectionHelper.findField(EntityLivingBase.class, (String)"field_184631_bt");

    public static void forceSetRegistryName(IForgeRegistryEntry.Impl<?> impl, String str) {
        if (impl == null) {
            return;
        }
        ObfuscationReflectionHelper.setPrivateValue(IForgeRegistryEntry.Impl.class, impl, (Object)GameData.checkPrefix((String)str, (boolean)true), (String)"registryName");
    }

    public static void resetAutogenName(Item impl) {
        if (impl instanceof ItemSwordBase) {
            ObfuscationReflectionHelper.setPrivateValue(ItemSwordBase.class, (Object)((ItemSwordBase)impl), null, (String)"displayName");
        }
        if (impl instanceof ItemCrossbow) {
            ObfuscationReflectionHelper.setPrivateValue(ItemCrossbow.class, (Object)((ItemCrossbow)impl), null, (String)"displayName");
        }
        if (impl instanceof ItemThrowingWeapon) {
            ObfuscationReflectionHelper.setPrivateValue(ItemThrowingWeapon.class, (Object)((ItemThrowingWeapon)impl), null, (String)"displayName");
        }
    }

    public static void executeInNTicks(final Runnable executor, int executeIn) {
        new Object(){
            private int ticks = 0;
            private float waitTicks;

            public void start(int waitTicks) {
                this.waitTicks = waitTicks;
                MinecraftForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void tick(TickEvent.ServerTickEvent event) {
                if (event.phase == TickEvent.Phase.END) {
                    ++this.ticks;
                    if ((float)this.ticks >= this.waitTicks) {
                        this.run();
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }

            private void run() {
                executor.run();
            }
        }.start(executeIn);
    }

    public static RayTraceResult rayTrace(EntityLivingBase entityLiving, double maxRange, List<Entity> exclude) {
        return Utils.rayTrace(entityLiving, maxRange, exclude, true);
    }

    public static RayTraceResult rayTrace(EntityLivingBase entityLiving, double maxRange, List<Entity> exclude, boolean affectedByBlocks) {
        Vec3d start = entityLiving.func_174824_e(0.5f);
        Vec3d lookVec = entityLiving.func_70040_Z();
        exclude = exclude == null ? new ArrayList<Entity>() : new ArrayList<Entity>(exclude);
        exclude.add((Entity)entityLiving);
        return Utils.rayTrace(start, lookVec, entityLiving.field_70170_p, maxRange, exclude::contains, affectedByBlocks, false);
    }

    public static RayTraceResult rayTrace(Vec3d start, Vec3d direction, World world, double maxRange, Predicate<Entity> exclude, boolean affectedByBlocks, boolean ignoreNoBounding) {
        Vec3d end = start.func_178787_e(direction.func_186678_a(maxRange));
        RayTraceResult firstTrace = affectedByBlocks ? world.func_147447_a(start, end, false, ignoreNoBounding, true) : null;
        Vec3d endTrace = firstTrace != null ? firstTrace.field_72307_f : end;
        AxisAlignedBB area = new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, endTrace.field_72450_a, endTrace.field_72448_b, endTrace.field_72449_c);
        List entities = world.func_72839_b(null, area);
        Entity closestValid = null;
        double closestDistSq = Double.MAX_VALUE;
        for (Entity e : entities) {
            double distSq;
            RayTraceResult intercept;
            if (!(e instanceof EntityLivingBase) || exclude != null && exclude.test(e) || (intercept = e.func_174813_aQ().func_72327_a(start, end)) == null || !(closestDistSq > (distSq = intercept.field_72307_f.func_72436_e(start)))) continue;
            closestValid = e;
            closestDistSq = distSq;
        }
        if (closestValid != null) {
            return new RayTraceResult(closestValid);
        }
        if (firstTrace != null) {
            return firstTrace;
        }
        return new RayTraceResult(RayTraceResult.Type.MISS, end, EnumFacing.DOWN, new BlockPos(end));
    }

    public static Vec3d getCenter(AxisAlignedBB box) {
        return new Vec3d(box.field_72340_a + (box.field_72336_d - box.field_72340_a) * 0.5, box.field_72338_b + (box.field_72337_e - box.field_72338_b) * 0.5, box.field_72339_c + (box.field_72334_f - box.field_72339_c) * 0.5);
    }

    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static NBTTagCompound getOrEmptyTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return new NBTTagCompound();
        }
        return stack.func_77978_p();
    }

    public static void refreshAttributes(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        try {
            block10: for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ItemStack itemstack;
                switch (entityequipmentslot.func_188453_a()) {
                    case HAND: {
                        itemstack = (ItemStack)((NonNullList)handInventory.get(entity)).get(entityequipmentslot.func_188454_b());
                        break;
                    }
                    case ARMOR: {
                        itemstack = (ItemStack)((NonNullList)armorArray.get(entity)).get(entityequipmentslot.func_188454_b());
                        break;
                    }
                    default: {
                        continue block10;
                    }
                }
                ItemStack itemstack1 = entity.func_184582_a(entityequipmentslot);
                if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                if (!ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)itemstack1, (ItemStack)itemstack)) {
                    ((WorldServer)entity.field_70170_p).func_73039_n().func_151247_a((Entity)entity, (Packet)new SPacketEntityEquipment(entity.func_145782_y(), entityequipmentslot, itemstack1));
                }
                MinecraftForge.EVENT_BUS.post((Event)new LivingEquipmentChangeEvent(entity, entityequipmentslot, itemstack, itemstack1));
                if (!itemstack.func_190926_b()) {
                    entity.func_110140_aT().func_111148_a(itemstack.func_111283_C(entityequipmentslot));
                }
                if (!itemstack1.func_190926_b()) {
                    entity.func_110140_aT().func_111147_b(itemstack1.func_111283_C(entityequipmentslot));
                }
                switch (entityequipmentslot.func_188453_a()) {
                    case HAND: {
                        ((NonNullList)handInventory.get(entity)).set(entityequipmentslot.func_188454_b(), (Object)(itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l()));
                        continue block10;
                    }
                    case ARMOR: {
                        ((NonNullList)armorArray.get(entity)).set(entityequipmentslot.func_188454_b(), (Object)(itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l()));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void attackAsPlayerWithItem(EntityPlayer player, Entity target, ItemStack stack) {
        try {
            ItemStack currentHandSlot = player.func_184614_ca();
            int orig = ticksSinceLastAtt.getInt(player);
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
            ticksSinceLastAtt.set(player, orig);
            Utils.refreshAttributes((EntityLivingBase)player);
            System.out.println(target);
            player.func_71059_n(target);
            player.func_184611_a(EnumHand.MAIN_HAND, currentHandSlot);
            Utils.refreshAttributes((EntityLivingBase)player);
            ticksSinceLastAtt.set(player, 0);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

